#include <dci.h>
#include <p30fxxxx.h>

/* DCI is enabled only for following devices */ 
#if defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) ||defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6014__)

/**************************************************************************
*    Function Name  : ConfigIntDCI
*    Description    : This Function Configures DCI Interrupt and sets  
*					  Interrupt Priority
*    Parameters     : unsigned int:config
*	 Return Value   : None
***************************************************************************/

void ConfigIntDCI(unsigned int config)
{
     IFS2bits.DCIIF = 0; 	                 /* Clear IF bit */
     IPC10bits.DCIIP = (config & 0x0007);     /* Assign Interrupt Priority */ 
     IEC2bits.DCIIE = (config & 0x0008)>>3;   /* Enable/disable Interrupt */ 
}

#endif
